#include <stdio.h>
#include <stdlib.h>

typedef long long ll;

typedef struct {
    ll w, v;
    double ratio;
    int id;
} Item;

int cmp(const void *a, const void *b) {
    Item *x = (Item *)a;
    Item *y = (Item *)b;
    if (x->ratio < y->ratio) return 1;
    if (x->ratio > y->ratio) return -1;
    return 0;
}

int main() {
    int N;
    ll W;
    double eps;
    scanf("%d %lld %lf", &N, &W, &eps);

    Item a[305];
    for (int i = 0; i < N; i++) {
        scanf("%lld %lld", &a[i].w, &a[i].v);
        a[i].ratio = (double)a[i].v / a[i].w;
        a[i].id = i + 1;
    }

    qsort(a, N, sizeof(Item), cmp);

    ll curW = 0;
    int chosen[305], k = 0;

    for (int i = 0; i < N; i++) {
        if (curW + a[i].w <= W) {
            curW += a[i].w;
            chosen[k++] = a[i].id;
        }
    }

    printf("%d\n", k);
    for (int i = 0; i < k; i++)
        printf("%d ", chosen[i]);
    printf("\n");

    return 0;
}